class MH2_Pickup_Shielding extends MH2_Pickup;

#exec TEXTURE IMPORT NAME=Skin_Shielding FILE=Textures\Skin_Shielding.bmp Group=Pickups MIPS=ON

#exec mesh import mesh=MH2_Shielding anivfile=Models\MH2_Shielding_a.3d datafile=Models\MH2_Shielding_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=MH2_Shielding x=0 y=0 z=0
#exec mesh sequence mesh=MH2_Shielding seq=All startframe=0 numframes=1

#exec meshmap new meshmap=MH2_Shielding mesh=MH2_Shielding
#exec meshmap scale meshmap=MH2_Shielding x=0.12757 y=0.12757 z=0.25515

function bool HandlePickupQuery( inventory Item )
{
local inventory Inv;

	if ( item.class == class ) 
		{
		
		Charge = Item.Charge;
			
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		if ( PickupMessageClass == None )
			Pawn(Owner).ClientMessage(PickupMessage, 'Pickup');
		else
			Pawn(Owner).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
		Item.PlaySound (PickupSound,,2.0);
		Item.SetReSpawn();
		return true;				
		}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy, S;

	Copy = Super.SpawnCopy(Other);

	return Copy;
}

defaultproperties
{
     PickupMessage="Woot! You got the Super Shielding."
     ItemName="Super shielding"
     RespawnTime=30.000000
     Charge=500
     ArmorAbsorption=75
     Mesh=Mesh'MH2_Shielding'
     DrawScale=0.75
     CollisionRadius=25
     CollisionHeight=32
     PickupViewMesh=Mesh'MH2_Shielding'
     MultiSkins(0)=Texture'Skin_Shielding'
     PickupSound=Sound'UnrealShare.Pickups.ArmorSnd'
}
